/* THIS PROGRAM IS PROVIDED "AS IS". TI MAKES NO WARRANTIES OR REPRESENTATIONS,
 * EITHER EXPRESS, IMPLIED OR STATUTORY, INCLUDING ANY IMPLIED WARRANTIES OF
 * MERCHANTABILITY, FITNESS FOR A PARTICULAR PURPOSE, LACK OF VIRUSES, ACCURACY
 * OR COMPLETENESS OF RESPONSES, RESULTS AND LACK OF NEGLIGENCE. TI DISCLAIMS
 * ANY WARRANTY OF TITLE, QUIET ENJOYMENT, QUIET POSSESSION, AND NON-INFRINGEMENT
 * OF ANY THIRD PARTY INTELLECTUAL PROPERTY RIGHTS WITH REGARD TO THE PROGRAM OR
 * YOUR USE OF THE PROGRAM.
 * IN NO EVENT SHALL TI BE LIABLE FOR ANY SPECIAL, INCIDENTAL, CONSEQUENTIAL OR
 * INDIRECT DAMAGES, HOWEVER CAUSED, ON ANY THEORY OF LIABILITY AND WHETHER OR
 * NOT TI HAS BEEN ADVISED OF THE POSSIBILITY OF SUCH DAMAGES, ARISING IN ANY WAY
 * OUT OF THIS AGREEMENT, THE PROGRAM, OR YOUR USE OF THE PROGRAM.  EXCLUDED
 * DAMAGES INCLUDE, BUT ARE NOT LIMITED TO, COST OF REMOVAL OR REINSTALLATION,
 * COMPUTER TIME, LABOR COSTS, LOSS OF GOODWILL, LOSS OF PROFITS, LOSS OF
 * SAVINGS, OR LOSS OF USE OR INTERRUPTION OF BUSINESS. IN NO EVENT WILL TI'S
 * AGGREGATE LIABILITY UNDER THIS AGREEMENT OR ARISING OUT OF YOUR USE OF THE
 * PROGRAM EXCEED FIVE HUNDRED DOLLARS (U.S.$500).
 * Unless otherwise stated, the Program written and copyrighted by Texas
 * Instruments is distributed as "freeware".  You may, only under TI's copyright
 * in the Program, use and modify the Program without any charge or restriction.
 * You may distribute to third parties, provided that you transfer a copy of this
 * license to the third party and the third party agrees to these terms by its
 * first use of the Program. You must reproduce the copyright notice and any
 * other legend of ownership on each copy or partial copy, of the Program.
 * You acknowledge and agree that the Program contains copyrighted material,
 * trade secrets and other TI proprietary information and is protected by
 * copyright laws, international copyright treaties, and trade secret laws, as
 * well as other intellectual property laws.  To protect TI's rights in the
 * Program, you agree not to decompile, reverse engineer, disassemble or
 * otherwise translate any object code versions of the Program to a
 * human-readable form.  You agree that in no event will you alter, remove or
 * destroy any copyright notice included in the Program.  TI reserves all rights
 * not specifically granted under this license. Except as specifically provided
 * herein, nothing in this agreement shall be construed as conferring by
 * implication, estoppel, or otherwise, upon you, any license or other right
 * under any TI patents, copyrights or trade secrets.
 * You may not use the Program in non-TI devices. */


//******************************************************************************
//
//  init.c
//  Initialization of uC
//
//  Matthias Ulmann, Design Services - EMEA Power Management
//  Texas Instruments, Inc.
//
//******************************************************************************


#include "main.h"



// general initializations
void init_general(void)
{  
  // set frequency of DCO to 16MHz, using calibrated register settings
  BCSCTL1 = CALBC1_16MHZ;
  DCOCTL = CALDCO_16MHZ;
  
  // select DCO for MCLK
  clear_bit(BCSCTL2, SELM0);
  clear_bit(BCSCTL2, SELM1);
  
  // no divider for MCLK
  clear_bit(BCSCTL2, DIVM0);
  clear_bit(BCSCTL2, DIVM1);
  
  // select DCO for SMCLK
  clear_bit(BCSCTL2, SELS);
  
  // no divider for SMCLK
  clear_bit(BCSCTL2, DIVS0);
  clear_bit(BCSCTL2, DIVS1);
  
  // disable second crystal oscillator XT2
  clear_bit(BCSCTL1, XT2OFF);
}



// initialization of digital outputs (low side FETs)
void init_digital_outputs(void)
{
  // pins used as general I/O, LS_A / LS_B
  clear_bit(LS_PSEL, LS_A_pin);
  clear_bit(LS_PSEL, LS_B_pin);
  
  // set pins as output, LS_A / LS_B
  set_bit(LS_PDIR, LS_A_pin);
  set_bit(LS_PDIR, LS_B_pin);

  // set outputs high, LS_A / LS_B
  set_bit(LS_POUT, LS_A_pin);
  set_bit(LS_POUT, LS_B_pin);
}



// initialization of PWM outputs (high side FETs)
void init_PWM_outputs(void)
{
  // pins used as output for timer, HS_A_1 / HS_A_2 / HS_B_1 / HS_B_2
  set_bit(HS_PSEL, HS_A_1_pin);
  set_bit(HS_PSEL, HS_A_2_pin);
  set_bit(HS_PSEL, HS_B_1_pin);
  set_bit(HS_PSEL, HS_B_2_pin);
  
  // set pins as output, HS_A_1 / HS_A_2 / HS_B_1 / HS_B_2
  set_bit(HS_PDIR, HS_A_1_pin);
  set_bit(HS_PDIR, HS_A_2_pin);
  set_bit(HS_PDIR, HS_B_1_pin);
  set_bit(HS_PDIR, HS_B_2_pin);
  
  // set outputs low, HS_A_1 / HS_A_2 / HS_B_1 / HS_B_2
  clear_bit(HS_POUT, HS_A_1_pin);
  clear_bit(HS_POUT, HS_A_2_pin);
  clear_bit(HS_POUT, HS_B_1_pin);
  clear_bit(HS_POUT, HS_B_2_pin);
}



// initialization of digital inputs (neutral, line)
void init_digital_inputs(void)
{
  // pins used as general I/O, NEUTRAL / LINE
  clear_bit(DIG_IN_PSEL, NEUTRAL_pin);
  clear_bit(DIG_IN_PSEL, LINE_pin);
  
  // set pins as input, NEUTRAL / LINE
  clear_bit(DIG_IN_PDIR, NEUTRAL_pin);
  clear_bit(DIG_IN_PDIR, LINE_pin);

  // disable pullup/down resistors
  clear_bit(DIG_IN_POUT, NEUTRAL_pin);
  clear_bit(DIG_IN_POUT, LINE_pin);
}



// initialization of analog input (current)
void init_analog_input(void)
{
  // select internal reference and GND
  clear_bit(ADC10CTL0, SREF2);
  clear_bit(ADC10CTL0, SREF1);
  set_bit(ADC10CTL0, SREF0);
  
  // set sample-and-hold time to 16 ADC10CLKs
  set_bit(ADC10CTL0, ADC10SHT1);
  clear_bit(ADC10CTL0, ADC10SHT0);
  
  // set the sample rate to 200 ksps
  clear_bit(ADC10CTL0, ADC10SR);
  
  // no reference output
  clear_bit(ADC10CTL0, REFOUT);
  
  // reference always buffered
  clear_bit(ADC10CTL0, REFBURST);
  
  // single sample and conversion
  clear_bit(ADC10CTL0, MSC);
  
  // set reference generator voltage to 2.5V
  set_bit(ADC10CTL0, REF2_5V);
  
  // switch reference generator on
  set_bit(ADC10CTL0, REFON);
  
  // switch ADC on
  set_bit(ADC10CTL0, ADC10ON);
  
  // no interrupt
  clear_bit(ADC10CTL0, ADC10IE);
  
  // select P1.0/A0 as input
  clear_bit(ADC10CTL1, INCH3);
  clear_bit(ADC10CTL1, INCH2);
  clear_bit(ADC10CTL1, INCH1);
  clear_bit(ADC10CTL1, INCH0);
  
  // ADC10SC bit as sample-and-hold source
  clear_bit(ADC10CTL1, SHS1);
  clear_bit(ADC10CTL1, SHS0);
  
  // ADC10 data as straight binary
  clear_bit(ADC10CTL1, ADC10DF);
  
  // sample-and-hold signal not inverted
  clear_bit(ADC10CTL1, ISSH);
  
  // no clock divider
  clear_bit(ADC10CTL1, ADC10DIV2);
  clear_bit(ADC10CTL1, ADC10DIV1);
  clear_bit(ADC10CTL1, ADC10DIV0);
  
  // MCLK as source for ADC
  set_bit(ADC10CTL1, ADC10SSEL1);
  clear_bit(ADC10CTL1, ADC10SSEL0);
  
  // single channel single conversion
  clear_bit(ADC10CTL1, CONSEQ1);
  clear_bit(ADC10CTL1, CONSEQ0);
}



// initialization of timerA for PWM
void init_timerA(void)
{
  // reset timer
  set_bit(TACTL, TACLR);
  
  // SMCLK as source for Timer A
  clear_bit(TACTL, TASSEL0);
  set_bit(TACTL, TASSEL1);
  
  // input divider 1 -> counter is running @ 16MHz
  clear_bit(TACTL, ID0);
  clear_bit(TACTL, ID1);
  
  // timer in up/down mode
  set_bit(TACTL, MC0);
  set_bit(TACTL, MC1);
  
  // set compare register for 5us
  // 200kHz -> 5us, 5us / 1/16MHz = 40 steps
  // PWM period is half
  TACCR0 = 20;
  TACCR1 = 20;
  
  // no capture
  clear_bit(TACCTL0, CM0);
  clear_bit(TACCTL0, CM1);
  clear_bit(TACCTL1, CM0);
  clear_bit(TACCTL1, CM1);
  
  // compare mode
  clear_bit(TACCTL0, CAP);
  clear_bit(TACCTL1, CAP);
  
  // OOUT0: pins are controlled by timer A, "toggle mode"
  clear_bit(TACCTL0, OUTMOD0);
  clear_bit(TACCTL0, OUTMOD1);
  set_bit(TACCTL0, OUTMOD2);
  
  // OOUT1: pins are controlled by timer A, "toggle mode"
  clear_bit(TACCTL1, OUTMOD0);
  clear_bit(TACCTL1, OUTMOD1);
  set_bit(TACCTL1, OUTMOD2);
  
  // enable compare interrupt
  set_bit(TACCTL0, CCIE);
  clear_bit(TACCTL1, CCIE);
}
